/* Curved corner script for Photoshop
 *
 * Copyright 2010 Ryan Nutt
 * http://photoartsforum.com
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>
 */
 
doResize();
 
function doResize() {
	
	/* Save current settings so we can reset them later	*/
	var startRulerUnits = app.preferences.rulerUnits;
	var startTypeUnits = app.preferences.typeUnits;
	var startDisplayDialogs = app.displayDialogs; 
	
	/* Change everything to pixels	*/
	app.preferences.rulerUnits = Units.PIXELS;
	app.preferences.typeUnits = TypeUnits.PIXELS;
	app.displayDialogs = DialogModes.NO;
	
	/* Prompt for the radius of the curve	*/
	var radius = -1;
	do {
		radius = prompt('Enter a radius for the corners.  Must be numeric, greater than 0, and less than or equal to 100.', '10', 'Corner Radius from http://PhotoArtsForum.com');
		if (radius==null) { break; }
	} while (radius <= 0 || radius>100 || isNaN(radius));
	
	if (radius!=null) {	
		/* We don't want to do anything to the document if they clicked cancel,
		 * but we do need to get to the end of this function so that we can reset
		 * the settings back to where they started.
		 */
	
		/* Load a few more variables	*/
		var doc = app.activeDocument;
		var docWidth = doc.width;
		var docHeight = doc.height;
		
		/* This won't work if the layer we're working on is a background
		 * layer.  So we're going to set it so it's not
		 */
		doc.activeLayer.isBackgroundLayer = false;
		
		
		/* We need to resize the canvas so that there's room to do the
		 * smoothing.  PS doesn't seem to like us smoothing when the 
		 * selection is against the edges.
		 */
		doc.resizeCanvas(docWidth + (radius*2), docHeight + (radius * 2)); 
		
		/* Select the original section	*/
		doc.selection.select(Array(
			Array(radius,radius), 
			Array(radius,doc.height - (radius)), 
			Array(doc.width - (radius),doc.height -(radius)), 
			Array(doc.width - (radius),radius))); 
		
		/* Smooth, invert, and delete the parts we don't want	*/
		doc.selection.smooth(radius);	
		doc.selection.invert();	
		doc.selection.clear(); 

		/* We want to leave everything deselected	*/
		doc.selection.deselect(); 
		
		/* Trim off the extra canvas we added earlier	*/
		doc.trim();
		}
		
	/* Put the settings back where they started	*/
	app.preferences.rulerUnits = startRulerUnits;
	app.preferences.typeUnits = startTypeUnits;
	app.displayDialogs = startDisplayDialogs; 
}